<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Form;

use Laminas\Form\Form;

class ChangeOrderAmountForm extends Form
{
    public function __construct($name = 'change-order-amount-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'orderChangeType',
            'attributes'    => [
                'id'            => 'orderChangeType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'orderChangeNum',
            'attributes'    => [
                'id'            => 'orderChangeNum',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'orderChangeInfo',
            'attributes'    => [
                'id'            => 'orderChangeInfo',
                'class'         => 'form-control',
                'rows'   => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'orderChangeType',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => ['+', '-']
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'orderChangeNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'orderChangeInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}