<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Form;

use Doctrine\ORM\EntityManager;
use Laminas\Form\Form;
use Sales\Validator\ShipOneOrderExpressNumberValidator;
use Sales\Validator\ShipOneOrderGoodsValidator;

class EditOneOrderExpressNumberForm extends Form
{
    private $orderId;
    private $entityManager;

    public function __construct($orderId, EntityManager $entityManager, $name = 'edit-order-express-number-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->orderId = $orderId;
        $this->entityManager = $entityManager;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'goodsId'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'expressNumber'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'goodsId',
            'required'  => true,
            'validators'=> [
                [
                    'name' => ShipOneOrderGoodsValidator::class,
                    'options' => [
                        'entityManager' => $this->entityManager,
                        'orderId'       => $this->orderId
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'expressNumber',
            'required'  => true,
            'validators'=> [
                [
                    'name' => ShipOneOrderExpressNumberValidator::class
                ]
            ]
        ]);
    }
}