<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Form;

use Laminas\Form\Form;
use Sales\Validator\PayOrderBalanceValidator;

class PayOrderForm extends Form
{
    private $userMoney;
    private $baseOrderAmount;

    public function __construct($userMoney, $baseOrderAmount, $name = 'pay-order-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->userMoney = $userMoney;
        $this->baseOrderAmount = $baseOrderAmount;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'paymentCode',
            'attributes'    => [
                'id'     => 'paymentCode',
                'class'  => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'statusInfo',
            'attributes'    => [
                'id'     => 'statusInfo',
                'class'  => 'form-control',
                'rows'   => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'paymentCode',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => PayOrderBalanceValidator::class,
                    'options'   => [
                        'userMoney' => $this->userMoney,
                        'baseOrderAmount' => $this->baseOrderAmount
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'statusInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);
    }
}