<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchOrderGoodsReturnForm extends Form
{
    private $translator;

    public function __construct($name = 'search-order-goods-return-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'goods_name',
            'attributes'    => [
                'id'            => 'goods_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('商品名称')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'user_name',
            'attributes'    => [
                'id'            => 'user_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('申请人')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'return_type',
            'attributes'    => [
                'id'            => 'return_type',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'return_state',
            'attributes'    => [
                'id'            => 'return_state',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'start_add_time',
            'attributes'    => [
                'id'            => 'start_add_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_add_time',
            'attributes'    => [
                'id'            => 'end_add_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'start_review_time',
            'attributes'    => [
                'id'            => 'start_review_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_review_time',
            'attributes'    => [
                'id'            => 'end_review_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'goods_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'return_type',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'return_state',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'start_add_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_add_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'start_review_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_review_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);
    }
}