<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchOrderShipForm extends Form
{
    private $translator;

    public function __construct($name = 'search-order-ship-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'express_number',
            'attributes'    => [
                'id'            => 'express_number',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('发货单号')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'delivery_name',
            'attributes'    => [
                'id'            => 'delivery_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('快递公司')
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'one_ship',
            'attributes'    => [
                'id'            => 'one_ship'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'order_sn',
            'attributes'    => [
                'id'            => 'order_sn',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('订单编号')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'start_time',
            'attributes'    => [
                'id'            => 'start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_time',
            'attributes'    => [
                'id'            => 'end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'true_name',
            'attributes'    => [
                'id'            => 'true_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('收货人')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'express_start_time',
            'attributes'    => [
                'id'            => 'express_start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'express_end_time',
            'attributes'    => [
                'id'            => 'express_end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'express_state',
            'attributes'    => [
                'id'            => 'express_state',
                'class'         => 'form-control input-sm'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'express_number',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'delivery_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'one_ship',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'order_sn',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'true_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'express_start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'express_end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'express_state',
            'required'  => false
        ]);
    }
}