<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Form;

use Doctrine\ORM\EntityManager;
use Laminas\Form\Form;
use Sales\Validator\ShipOneOrderDeliveryValidator;
use Sales\Validator\ShipOneOrderExpressNumberValidator;
use Sales\Validator\ShipOneOrderGoodsValidator;

class ShipOneOrderForm extends Form
{
    private $orderId;
    private $entityManager;

    public function __construct($orderId, EntityManager $entityManager, $name = 'ship-one-order-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->orderId = $orderId;
        $this->entityManager = $entityManager;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'deliveryMode',
            'attributes'    => [
                'id'            => 'deliveryMode',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsId'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'deliveryId'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'expressNumber'
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'statusInfo',
            'attributes'    => [
                'id'     => 'statusInfo',
                'class'  => 'form-control',
                'rows'   => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'deliveryMode',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 2]
                    ]
                ]
            ]
        ]);


        $inputFilter->add([
            'name'      => 'statusInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsId',
            'required'  => true,
            'validators'=> [
                [
                    'name' => ShipOneOrderGoodsValidator::class,
                    'options' => [
                        'entityManager' => $this->entityManager,
                        'orderId'       => $this->orderId
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryId',
            'required'  => true,
            'validators'=> [
                [
                    'name' => ShipOneOrderDeliveryValidator::class,
                    'options' => [
                        'entityManager' => $this->entityManager
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'expressNumber',
            'required'  => true,
            'validators'=> [
                [
                    'name' => ShipOneOrderExpressNumberValidator::class
                ]
            ]
        ]);
    }
}