<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository;

use Admin\Data\Common;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Sales\Entity\Order;
use Sales\Entity\OrderDeliveryAddress;
use Sales\Repository\QuerySearch\OrderShipSearch;

class OrderDeliveryAddressRepository extends EntityRepository
{
    /**
     * 发货单列表，只显示 快递配送 的发货单信息，在线支付已支付的和货到付款有效订单
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findOrderShipList(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('d',
                'o.orderSn', 'o.expressTime', 'o.expressNumber', 'o.deliveryMode', 'o.deliveryName', 'o.orderAddTime'
            )
            ->from(OrderDeliveryAddress::class, 'd')
            ->innerJoin(Order::class, 'o', Join::WITH, 'd.orderId = o.orderId')
            ->where(
                $query->expr()->orX(
                    $query->expr()->andX(
                        $query->expr()->gte('o.orderStatus', Common::orderStatusCode('WAIT_PAYMENT')),
                        $query->expr()->eq('o.paymentType', ':paymentType1')
                    ),
                    $query->expr()->andX(
                        $query->expr()->gte('o.orderStatus', Common::orderStatusCode('WAIT_GOODS_ARRIVE')),
                        $query->expr()->eq('o.paymentType', ':paymentType2')
                    )
                )
            )->setParameter('paymentType1', 'CashOnDelivery')->setParameter('paymentType2', 'OnlinePay')
            ->andWhere('o.deliveryType = :deliveryType')->setParameter('deliveryType', 'delivery')
            ->orderBy('d.orderId', 'DESC');

        $query = OrderShipSearch::querySearchData($search, $query);

        return $query->getQuery();
    }
}