<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository;

use Doctrine\ORM\EntityRepository;
use Sales\Entity\OrderDiscountRecord;

class OrderDiscountRecordRepository extends EntityRepository
{
    /**
     * 获取订单的优惠总额
     * @param $orderId
     * @return string
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findSumOrderDiscount($orderId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('SUM(d.discountCost)')->from(OrderDiscountRecord::class, 'd')
            ->where('d.orderId = :orderId')->setParameter('orderId', $orderId);

        return number_format($query->getQuery()->getSingleScalarResult(), 2, '.', '');
    }
}