<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\Goods;
use Sales\Entity\OrderGoodsEvaluationBase;
use Sales\Repository\QuerySearch\OrderGoodsEvaluationBaseSearch;

class OrderGoodsEvaluationBaseRepository extends EntityRepository
{
    /**
     * 商品基本评价列表
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findOrderGoodsEvaluationBase(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('b', 'g.goodsName')
            ->from(OrderGoodsEvaluationBase::class, 'b')
            ->innerJoin(Goods::class, 'g', Join::WITH, 'b.goodsId = g.goodsId')
            ->orderBy('b.evaluationLastTime', 'DESC');

        $query = OrderGoodsEvaluationBaseSearch::querySearchData($search, $query);

        return $query->getQuery();
    }
}