<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Sales\Entity\OrderGoodsEvaluation;
use User\Entity\User;

class OrderGoodsEvaluationRepository extends EntityRepository
{
    /**
     * 后台单个商品评价的列表
     * @param $goodsId
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findGoodsEvaluationList($goodsId, array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('e')
            ->from(OrderGoodsEvaluation::class, 'e')
            ->where('e.goodsId = :goodsId')->setParameter('goodsId', $goodsId)
            ->orderBy('e.evaluationId', 'DESC');

        return $query->getQuery();
    }

    /*==============================================下面为前台调用==============================================*/

    /**
     * 前台商品评价列表
     * @param $goodsId
     * @return \Doctrine\ORM\Query
     */
    public function findShopGoodsEvaluationList($goodsId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('e', 'u.userAvatar')
            ->from(OrderGoodsEvaluation::class, 'e')
            ->leftJoin(User::class, 'u', Join::WITH, 'e.userId = u.userId')
            ->where('e.evaluationShowState = 1')
            ->andWhere('e.goodsId = :goodsId')->setParameter('goodsId', $goodsId)
            ->orderBy('e.evaluationId', 'DESC');

        return $query->getQuery();
    }
}