<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class OrderGoodsReturnSearch
{
    /**
     * 售后检索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if (isset($search['goods_name']) && !empty($search['goods_name']))                  $queryBuilder->andWhere($queryBuilder->expr()->eq('g.goodsName', ':goodsName'))->setParameter('goodsName', $search['goods_name']);
        if (isset($search['user_name']) && !empty($search['user_name']))                    $queryBuilder->andWhere($queryBuilder->expr()->eq('r.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if (isset($search['return_type']) && is_numeric($search['return_type']))            $queryBuilder->andWhere($queryBuilder->expr()->eq('r.returnType', ':returnType'))->setParameter('returnType', $search['return_type']);
        if (isset($search['return_state']) && is_numeric($search['return_state']))          $queryBuilder->andWhere($queryBuilder->expr()->eq('r.returnState', ':returnState'))->setParameter('returnState', $search['return_state']);
        if (isset($search['start_add_time']) && !empty($search['start_add_time']))          $queryBuilder->andWhere($queryBuilder->expr()->gte('r.addTime', ':startAddTime'))->setParameter('startAddTime', strtotime($search['start_add_time'].' 00:00:00'));
        if (isset($search['end_add_time']) && !empty($search['end_add_time']))              $queryBuilder->andWhere($queryBuilder->expr()->lte('r.addTime', ':endAddTime'))->setParameter('endAddTime', strtotime($search['end_add_time'].' 23:59:59'));
        if (isset($search['start_review_time']) && !empty($search['start_review_time']))    $queryBuilder->andWhere($queryBuilder->expr()->gte('r.reviewTime', ':startReviewTime'))->setParameter('startReviewTime', strtotime($search['start_review_time'].' 00:00:00'));
        if (isset($search['end_review_time']) && !empty($search['end_review_time']))        $queryBuilder->andWhere($queryBuilder->expr()->lte('r.reviewTime', ':endReviewTime'))->setParameter('endReviewTime', strtotime($search['end_review_time'].' 23:59:59'));

        return $queryBuilder;
    }
}