<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class OrderSearch
{
    /**
     * 后台订单搜索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['order_sn']) && !empty($search['order_sn']))           $queryBuilder->andWhere($queryBuilder->expr()->eq('o.orderSn', ':orderSn'))->setParameter('orderSn', $search['order_sn']);
        if(isset($search['user_name']) && !empty($search['user_name']))         $queryBuilder->andWhere($queryBuilder->expr()->eq('o.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if(isset($search['payment_code']) && !empty($search['payment_code']))   $queryBuilder->andWhere($queryBuilder->expr()->eq('o.paymentCode', ':paymentCode'))->setParameter('paymentCode', $search['payment_code']);
        if(isset($search['order_status']) && is_numeric($search['order_status']) && $search['order_status'] >= 0) {
            $queryBuilder->andWhere($queryBuilder->expr()->eq('o.orderStatus', ':orderStatus'))->setParameter('orderStatus', $search['order_status']);
        }
        if(isset($search['payment_state']) && !empty($search['payment_state'])) $search['payment_state'] == 1 ? $queryBuilder->andWhere($queryBuilder->expr()->isNotNull('o.paymentFinishTime')) : $queryBuilder->andWhere($queryBuilder->expr()->isNull('o.paymentFinishTime'));
        if(isset($search['order_amount']) && $search['order_amount'] > 0)      $queryBuilder->andWhere($queryBuilder->expr()->eq('o.orderAmount', ':orderAmount'))->setParameter('orderAmount', $search['order_amount']);
        if(isset($search['delivery_type']) && !empty($search['delivery_type'])) $queryBuilder->andWhere($queryBuilder->expr()->eq('o.deliveryType', ':deliveryType'))->setParameter('deliveryType', $search['delivery_type']);
        if(isset($search['start_time']) && !empty($search['start_time']))       $queryBuilder->andWhere($queryBuilder->expr()->gte('o.orderAddTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if(isset($search['end_time']) && !empty($search['end_time']))           $queryBuilder->andWhere($queryBuilder->expr()->lte('o.orderAddTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));
        if(isset($search['start_payment_time']) && !empty($search['start_payment_time']))       $queryBuilder->andWhere($queryBuilder->expr()->gte('o.paymentFinishTime', ':startPaymentTime'))->setParameter('startPaymentTime', strtotime($search['start_payment_time'].' 00:00:00'));
        if(isset($search['end_payment_time']) && !empty($search['end_payment_time']))           $queryBuilder->andWhere($queryBuilder->expr()->lte('o.paymentFinishTime', ':endPaymentTime'))->setParameter('endPaymentTime', strtotime($search['end_payment_time'].' 23:59:59'));

        return $queryBuilder;
    }

    /**
     * 前台订单搜索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopQuerySearchData($search, QueryBuilder $queryBuilder)
    {
        if($search['orderStatus'] >= 0) {
            $statusArray = explode('-', $search['orderStatus']);
            if(count($statusArray) == 2) {
                $queryBuilder->andWhere($queryBuilder->expr()->gte('o.orderStatus', intval($statusArray[0])))->andWhere($queryBuilder->expr()->lte('o.orderStatus', intval($statusArray[1])));
            } else {
                $queryBuilder->andWhere($queryBuilder->expr()->eq('o.orderStatus', intval($statusArray[0])));
            }
        }
        return $queryBuilder;
    }
}