<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Repository\QuerySearch;


use Doctrine\ORM\QueryBuilder;

class OrderShipSearch
{
    /**
     * 后台发货单搜索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if (isset($search['express_number']) && !empty($search['express_number']))           $queryBuilder->andWhere($queryBuilder->expr()->eq('o.expressNumber', ':expressNumber'))->setParameter('expressNumber', $search['express_number']);
        if (isset($search['one_ship']) && !empty($search['one_ship'])) {
            $queryBuilder->andWhere($queryBuilder->expr()->eq('o.deliveryMode', 2));
        } else {
            if (isset($search['delivery_name']) && !empty($search['delivery_name'])) $queryBuilder->andWhere($queryBuilder->expr()->eq('o.deliveryName', ':deliveryName'))->setParameter('deliveryName', $search['delivery_name']);
        }
        if (isset($search['order_sn']) && !empty($search['order_sn']))                       $queryBuilder->andWhere($queryBuilder->expr()->eq('o.orderSn', ':orderSn'))->setParameter('orderSn', $search['order_sn']);
        if (isset($search['start_time']) && !empty($search['start_time']))                   $queryBuilder->andWhere($queryBuilder->expr()->gte('o.orderAddTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if (isset($search['end_time']) && !empty($search['end_time']))                       $queryBuilder->andWhere($queryBuilder->expr()->lte('o.orderAddTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));
        if (isset($search['true_name']) && !empty($search['true_name']))                     $queryBuilder->andWhere($queryBuilder->expr()->eq('d.trueName', ':trueName'))->setParameter('trueName', $search['true_name']);
        if (isset($search['express_start_time']) && !empty($search['express_start_time']))   $queryBuilder->andWhere($queryBuilder->expr()->gte('o.expressTime', ':expressStartTime'))->setParameter('expressStartTime', strtotime($search['express_start_time'].' 00:00:00'));
        if (isset($search['express_end_time']) && !empty($search['express_end_time']))       $queryBuilder->andWhere($queryBuilder->expr()->lte('o.expressTime', ':expressEndTime'))->setParameter('expressEndTime', strtotime($search['express_end_time'].' 23:59:59'));
        if (isset($search['express_state']) && !empty($search['express_state']))             $search['express_state'] == 1 ? $queryBuilder->andWhere($queryBuilder->expr()->isNotNull('o.expressTime')) : $queryBuilder->andWhere($queryBuilder->expr()->isNull('o.expressTime'));

        return $queryBuilder;
    }
}