<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Service;

use Doctrine\ORM\EntityManager;
use Sales\Entity\OrderChangeAmount;

class OrderChangeAmountManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加订单金额修改
     * @param array $data
     * @return OrderChangeAmount
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addOrderChangeAmount(array $data)
    {
        $orderChangeAmount = new OrderChangeAmount();
        $orderChangeAmount->valuesSet($data);

        $this->entityManager->persist($orderChangeAmount);
        $this->entityManager->flush();

        return $orderChangeAmount;
    }

    /**
     * 删除订单金额修改历史
     * @param $orderId
     * @return bool
     */
    public function deleteOrderChangeAmount($orderId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(OrderChangeAmount::class, 'o')->where('o.orderId = :orderId')->setParameter('orderId', $orderId);
        $qb->getQuery()->execute();

        return true;
    }
}