<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Service;

use Doctrine\ORM\EntityManager;
use Sales\Entity\OrderDiscountRecord;

class OrderDiscountRecordManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加订单优惠记录
     * @param array $data
     * @param $defaultCurrency
     * @return OrderDiscountRecord
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addOrderDiscountRecord(array $data, $defaultCurrency)
    {
        $data['discountCost'] = $data['discountCost'] * $defaultCurrency['rate'];

        $orderDiscountRecord = new OrderDiscountRecord();
        $orderDiscountRecord->valuesSet($data);

        $this->entityManager->persist($orderDiscountRecord);
        $this->entityManager->flush();

        return $orderDiscountRecord;
    }

    /**
     * 删除对应订单的优惠记录
     * @param $orderId
     * @return bool
     */
    public function deleteOrderDiscountRecord($orderId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(OrderDiscountRecord::class, 'd')->where('d.orderId = :orderId')->setParameter('orderId', $orderId);
        $qb->getQuery()->execute();

        return true;
    }
}