<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Service;

use Doctrine\ORM\EntityManager;
use Sales\Entity\OrderGoodsEvaluation;

class OrderGoodsEvaluationManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品评价
     * @param array $data
     * @return OrderGoodsEvaluation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addEvaluation(array $data)
    {
        $goodsEvaluation = new OrderGoodsEvaluation();
        $goodsEvaluation->valuesSet($data);

        $this->entityManager->persist($goodsEvaluation);
        $this->entityManager->flush();

        return $goodsEvaluation;
    }

    /**
     * 编辑商品评价
     * @param array $data
     * @param OrderGoodsEvaluation $orderGoodsEvaluation
     * @return OrderGoodsEvaluation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editEvaluation(array $data, OrderGoodsEvaluation $orderGoodsEvaluation)
    {
        $orderGoodsEvaluation->valuesSet($data);
        $this->entityManager->flush();

        return $orderGoodsEvaluation;
    }

    /**
     * 删除商品评价
     * @param OrderGoodsEvaluation $orderGoodsEvaluation
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteEvaluation(OrderGoodsEvaluation $orderGoodsEvaluation)
    {
        $this->entityManager->remove($orderGoodsEvaluation);
        $this->entityManager->flush();

        return true;
    }
}