<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Service;

use Doctrine\ORM\EntityManager;
use Sales\Entity\OrderGoodsReturn;

class OrderGoodsReturnManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加退款退货信息
     * @param array $data
     * @return OrderGoodsReturn
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsReturn(array $data)
    {
        $orderGoodsReturn = new OrderGoodsReturn();
        $orderGoodsReturn->valuesSet($data);

        $this->entityManager->persist($orderGoodsReturn);
        $this->entityManager->flush();

        return $orderGoodsReturn;
    }

    /**
     * 编辑更新退换货信息
     * @param array $data
     * @param OrderGoodsReturn $orderGoodsReturn
     * @return OrderGoodsReturn
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsReturn(array $data, OrderGoodsReturn $orderGoodsReturn)
    {
        $data['reviewTime'] = time();

        $orderGoodsReturn->valuesSet($data);
        $this->entityManager->flush();

        return $orderGoodsReturn;
    }

    /**
     * 删除退换货信息
     * @param OrderGoodsReturn $orderGoodsReturn
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteGoodsReturn(OrderGoodsReturn $orderGoodsReturn)
    {
        $this->entityManager->remove($orderGoodsReturn);
        $this->entityManager->flush();

        return true;
    }
}