<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Service;

use Doctrine\ORM\EntityManager;
use Sales\Entity\OrderStatus;

class OrderStatusManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加订单状态
     * @param array $data
     * @return OrderStatus
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addOrderStatus(array $data)
    {
        $orderStatus = new OrderStatus();
        $orderStatus->valuesSet($data);

        $this->entityManager->persist($orderStatus);
        $this->entityManager->flush();

        return $orderStatus;
    }

    /**
     * 删除订单状态记录
     * @param $orderId
     * @return bool
     */
    public function deleteOrderStatus($orderId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(OrderStatus::class, 's')->where('s.orderId = :orderId')->setParameter('orderId', $orderId);
        $qb->getQuery()->execute();

        return true;
    }
}