<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Validator;

use Laminas\Validator\AbstractValidator;

class PayOrderBalanceValidator extends AbstractValidator
{
    const NOT_SCALAR    = 'notScalar';
    const BALANCE_LOW   = 'balanceLow';

    protected $messageTemplates = [
        self::NOT_SCALAR     => "这不是一个标准输入值",
        self::BALANCE_LOW    => "余额不足无法支付，请使用其他支付方式"
    ];

    private $userMoney = 0;
    private $baseOrderAmount = 0;

    public function __construct($options = null)
    {
        if(isset($options['userMoney'])) $this->userMoney = $options['userMoney'];
        if(isset($options['baseOrderAmount'])) $this->baseOrderAmount = $options['baseOrderAmount'];

        parent::__construct($options);
    }

    public function isValid($value)
    {
        if (!is_scalar($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        //余额支付，判断客户余额是否够用
        if ($value == 'BalancePay') {
            if ($this->userMoney <= 0 || ($this->userMoney > 0 && $this->baseOrderAmount > $this->userMoney)) {
                $this->error(self::BALANCE_LOW);
                return false;
            }
        }

        return true;
    }
}