<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Validator;

use Laminas\Validator\AbstractValidator;

class ShipOneOrderExpressNumberValidator extends AbstractValidator
{
    const NOT_SCALAR        = 'notScalar';
    const EXPRESS_NUMBER_NOT_EMPTY = 'expressNumberNotEmpty';

    protected $messageTemplates = [
        self::NOT_SCALAR        => "这不是一个标准输入值",
        self::EXPRESS_NUMBER_NOT_EMPTY => "快递单号不能为空"
    ];

    public function __construct($options = null)
    {
        parent::__construct($options);
    }

    public function isValid($value)
    {
        $isValid = true;

        if (!is_array($value) && !empty($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        foreach ($value as $item) {
            if(empty($item)) {
                $this->error(self::EXPRESS_NUMBER_NOT_EMPTY);
                return false;
            }
        }

        return $isValid;
    }
}