<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\View;

use Admin\Data\Common;
use Laminas\Mvc\I18n\Translator;
use Laminas\View\Helper\AbstractHelper;

class SalesHelper extends AbstractHelper
{
    private $translator;

    public function __construct(
        Translator  $translator
    )
    {
        $this->translator   = $translator;
    }

    /**
     * 订单状态
     * @param $orderStatus
     * @return mixed
     */
    public function getOrderStatus($orderStatus)
    {
        return Common::orderStatus($this->translator)[$orderStatus];
    }

    /**
     * 订单状态编码
     * @param $statusStr
     * @return mixed
     */
    public function getOrderStatusCode($statusStr)
    {
        return Common::orderStatusCode($statusStr);
    }

    /**
     * 订单支付类型名称
     * @param $typeCode
     * @return mixed
     */
    public function getPaymentTypeName($typeCode)
    {
        return Common::paymentTypeName($typeCode, $this->translator);
    }

    /**
     * 订单配送类型名称
     * @param $typeCode
     * @return mixed
     */
    public function getDeliveryTypeName($typeCode)
    {
        return Common::deliveryTypeName($typeCode, $this->translator);
    }

    /**
     * 退货退款类型
     * @param $returnType
     * @return mixed
     */
    public function getOrderGoodsReturnType($returnType)
    {
        return Common::orderGoodsReturnType($this->translator)[$returnType];
    }

    /**
     * 退款退货状态
     * @param $state
     * @return mixed
     */
    public function getOrderGoodsReturnState($state)
    {
        return Common::orderGoodsReturnState($this->translator)[$state];
    }

    /**
     * 退款支付方式
     * @param $type
     * @return mixed
     */
    public function getOrderGoodsReturnPayType($type)
    {
        return Common::goodsReturnPayType($this->translator)[$type];
    }
}