<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop;

use Admin\Data\Common;
use Laminas\Router\Http\Literal;
use Laminas\Router\Http\Segment;
use Laminas\ServiceManager\Factory\InvokableFactory;
use Shop\Controller\BrandController;
use Shop\Controller\CartController;
use Shop\Controller\CheckoutController;
use Shop\Controller\ClassController;
use Shop\Controller\CmsController;
use Shop\Controller\Factory\BrandControllerFactory;
use Shop\Controller\Factory\CartControllerFactory;
use Shop\Controller\Factory\CheckoutControllerFactory;
use Shop\Controller\Factory\ClassControllerFactory;
use Shop\Controller\Factory\CmsControllerFactory;
use Shop\Controller\Factory\GoodsControllerFactory;
use Shop\Controller\Factory\HomeControllerFactory;
use Shop\Controller\Factory\HomeFavoritesControllerFactory;
use Shop\Controller\Factory\HomeOrderControllerFactory;
use Shop\Controller\Factory\HomeSecurityControllerFactory;
use Shop\Controller\Factory\HomeServiceControllerFactory;
use Shop\Controller\Factory\HomeUserAddressControllerFactory;
use Shop\Controller\Factory\HomeUserBalanceControllerFactory;
use Shop\Controller\Factory\HomeUserControllerFactory;
use Shop\Controller\Factory\HomeUserCouponControllerFactory;
use Shop\Controller\Factory\HomeUserIntegralControllerFactory;
use Shop\Controller\Factory\IndexControllerFactory;
use Shop\Controller\Factory\NotifyControllerFactory;
use Shop\Controller\Factory\PushReceiveControllerFactory;
use Shop\Controller\Factory\ReturnControllerFactory;
use Shop\Controller\Factory\SearchControllerFactory;
use Shop\Controller\Factory\UserControllerFactory;
use Shop\Controller\GoodsController;
use Shop\Controller\HomeController;
use Shop\Controller\HomeFavoritesController;
use Shop\Controller\HomeOrderController;
use Shop\Controller\HomeSecurityController;
use Shop\Controller\HomeServiceController;
use Shop\Controller\HomeUserAddressController;
use Shop\Controller\HomeUserBalanceController;
use Shop\Controller\HomeUserController;
use Shop\Controller\HomeUserCouponController;
use Shop\Controller\HomeUserIntegralController;
use Shop\Controller\IndexController;
use Shop\Controller\NotifyController;
use Shop\Controller\PushReceiveController;
use Shop\Controller\ReturnController;
use Shop\Controller\SearchController;
use Shop\Controller\UserController;
use Shop\Event\Factory\ShopListenerFactory;
use Shop\Event\ShopListener;
use Shop\Plugin\Factory\ShopPartialPluginFactory;
use Shop\Plugin\Factory\ShopPluginFactory;
use Shop\Plugin\ShopPartialPlugin;
use Shop\Plugin\ShopPlugin;
use Shop\Service\Factory\ShopUserManagerFactory;
use Shop\Service\ShopUserManager;
use Shop\View\Factory\ShopHelperFactory;
use Shop\View\FrontCurrency;
use Shop\View\ShopHelper;

$defaultTemplate = Common::getShopDefaultTemplate();

return [
    'router' => [
        'routes' => [
            'shop' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'default'   => [
                        'type'      => Segment::class,
                        'options'   => [
                            'route' => 'shop-[:action]',
                            'constraints' => [
                                'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                            ],
                            'defaults' => [
                                'action' => 'index'
                            ]
                        ]
                    ]
                ]
            ],

            'shop-brand' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-brand[/:action[/:id]]',
                    'defaults' => [
                        'controller' => BrandController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-class' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-class[/:action[/:id]]',
                    'defaults' => [
                        'controller' => ClassController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-goods' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-goods[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-cms' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-cms[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CmsController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-search' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-search[/:action[/:id]]',
                    'defaults' => [
                        'controller' => SearchController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-user[/:action[/:id]]',
                    'defaults' => [
                        'controller' => UserController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-cart' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-cart[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CartController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-checkout' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shopCheckout[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CheckoutController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-notify' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shopNotify[/:action[/:id]]',
                    'defaults' => [
                        'controller' => NotifyController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-home' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-home[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-user[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeUserController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-security' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-security[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeSecurityController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-order' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-order[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeOrderController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-user-addr' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-user-addr[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeUserAddressController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-user-integral' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-user-integral[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeUserIntegralController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-favorites' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-favorites[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeFavoritesController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-user-balance' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-user-balance[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeUserBalanceController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'home-user-coupon' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/home-user-coupon[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeUserCouponController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-return' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shopReturn[/:action[/:id]]',
                    'defaults' => [
                        'controller' => ReturnController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-service' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shop-service[/:action[/:id]]',
                    'defaults' => [
                        'controller' => HomeServiceController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'shop-push-receive' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/shopPushReceive[/:action[/:id]]',
                    'defaults' => [
                        'controller' => PushReceiveController::class,
                        'action'    => 'index'
                    ]
                ]
            ],
        ]

    ],

    'controllers' => [
        'factories' => [
            IndexController::class          => IndexControllerFactory::class,
            BrandController::class          => BrandControllerFactory::class,
            ClassController::class          => ClassControllerFactory::class,
            GoodsController::class          => GoodsControllerFactory::class,
            SearchController::class         => SearchControllerFactory::class,
            UserController::class           => UserControllerFactory::class,
            CmsController::class            => CmsControllerFactory::class,
            CartController::class           => CartControllerFactory::class,
            CheckoutController::class       => CheckoutControllerFactory::class,
            HomeController::class           => HomeControllerFactory::class,
            HomeUserController::class       => HomeUserControllerFactory::class,
            HomeUserCouponController::class => HomeUserCouponControllerFactory::class,
            HomeSecurityController::class   => HomeSecurityControllerFactory::class,
            HomeOrderController::class      => HomeOrderControllerFactory::class,
            HomeUserAddressController::class=> HomeUserAddressControllerFactory::class,
            HomeUserIntegralController::class => HomeUserIntegralControllerFactory::class,
            HomeFavoritesController::class  => HomeFavoritesControllerFactory::class,
            HomeUserBalanceController::class=> HomeUserBalanceControllerFactory::class,
            ReturnController::class         => ReturnControllerFactory::class,
            NotifyController::class         => NotifyControllerFactory::class,
            PushReceiveController::class    => PushReceiveControllerFactory::class,
            HomeServiceController::class    => HomeServiceControllerFactory::class,
        ]
    ],

    'service_manager' => [
        'factories' => [
            ShopUserManager::class  => ShopUserManagerFactory::class,

            ShopListener::class     => ShopListenerFactory::class
        ]
    ],

    'listeners' => [
        ShopListener::class
    ],

    'controller_plugins' => [
        'factories' => [
            ShopPlugin::class           => ShopPluginFactory::class,
            ShopPartialPlugin::class    => ShopPartialPluginFactory::class
        ],
        'aliases'   => [
            'shopPlugin'        => ShopPlugin::class,
            'shopPartialPlugin' => ShopPartialPlugin::class
        ]
    ],

    'view_helpers' => [
        'factories' => [
            ShopHelper::class   => ShopHelperFactory::class,
            FrontCurrency::class=> InvokableFactory::class
        ],
        'aliases' => [
            'shopHelper'    => ShopHelper::class,
            'frontCurrency' => FrontCurrency::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/'.$defaultTemplate.'/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_map' => [
            'shop/layout'         => __DIR__ . '/../view/' .$defaultTemplate. '/shop/layout/layout.phtml',
            'shop/header'         => __DIR__ . '/../view/' .$defaultTemplate. '/shop/layout/header.phtml',
            'shop/footer'         => __DIR__ . '/../view/' .$defaultTemplate. '/shop/layout/footer.phtml',
            'shop/ajaxPage'       => __DIR__ . '/../view/' .$defaultTemplate. '/shop/partial/ajaxPaginator.phtml',
            'shop/page'           => __DIR__ . '/../view/' .$defaultTemplate. '/shop/partial/paginator.phtml',
            'shop/message'        => __DIR__ . '/../view/' .$defaultTemplate. '/shop/layout/message.phtml',
            'shop/close'          => __DIR__ . '/../view/' .$defaultTemplate. '/shop/layout/close.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view/'.$defaultTemplate,
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ]
];