<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Common;

use Admin\Data\Common;

class ShopCommon
{

    /**
     * 支付列表
     * @param $onlinePayment 空 显示所有启用支付，true 显示在线支付，false 显示非在线支付
     * @param $currencyCode 货币code
     * @param array $excludePay 排除不需要显示的支付
     * @return array
     */
    public static function shopPaymentList($onlinePayment, $currencyCode, $excludePay = [])
    {
        return Common::paymentList(true, $onlinePayment, $currencyCode, $excludePay);
    }

    /**
     * 支付配置信息
     * @param $configFile
     * @return array|mixed
     */
    public static function shopPaymentConfig($configFile)
    {
        return Common::getPaymentConfig($configFile);
    }

    /**
     * 调用支付服务
     * @param $serviceName
     * @return mixed
     */
    public static function shopPaymentService($serviceName)
    {
        return Common::getPaymentService($serviceName);
    }

    /**
     * 生成在线支付code的数组
     * @param $paymentList
     * @return array
     */
    public static function createPaymentCodeArray($paymentList)
    {
        $array = [];
        if($paymentList) foreach ($paymentList as $paymentValue) {
            $array[] = $paymentValue['editAction'];
        }
        return $array;
    }

    /**
     * 送货时间
     * @return array|false|string[]
     */
    public static function shopShippingDate()
    {
        $orderConfig = Common::configValue('order', 'config');

        return $orderConfig['delivery_time_state'] == '1' ? (!empty($orderConfig['delivery_time']) ? explode("\r\n", $orderConfig['delivery_time']) : []) : [];
    }

    /**
     * 生成订单编号
     * @return string
     */
    public static function createOrderSn()
    {
        return date('ymd').substr(time(), -5) . substr(microtime(), 2, 5) . sprintf('%02d', rand(1000, 9999));
    }

    /**
     * 生成提货码
     * @param int $length 提货码长度，默认是 6位
     * @return false|string
     */
    public static function createTackCode($length = 6)
    {
        return substr(md5(microtime(true)), 0, $length);
    }
}