<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller;

use Doctrine\ORM\EntityManager;
use Goods\Entity\Goods;
use Goods\Entity\GoodsBrand;
use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\Mvc\I18n\Translator;

class BrandController extends AbstractActionController
{
    private $translator;
    private $entityManager;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;
    }

    /**
     * 品牌列表
     * @return array|\Laminas\View\Model\ViewModel
     */
    public function indexAction()
    {
        $this->layout()->setVariable('titleName', $this->translator->translate('商品品牌'));

        $brandList = $this->entityManager->getRepository(GoodsBrand::class)->findBy([], ['brandSort' => 'ASC']);

        $brandPartial = $this->shopPlugin()->shopPartial('brand');

        return ['brandList' => $brandList, 'brandPartial' => $brandPartial];
    }

    /**
     * 品牌商品列表
     * @return array|\Laminas\Http\Response
     */
    public function brandGoodsListAction()
    {
        $brandId = (int) $this->params()->fromRoute('id', 0);
        $brandInfo = $this->entityManager->getRepository(GoodsBrand::class)->findOneBy(['brandId' => $brandId]);
        if($brandInfo == null) return $this->redirect()->toRoute('shop');

        $searchArray['brandId'] = $brandId;
        $sort = $this->params()->fromQuery('sort', '');
        if(!empty($sort) && in_array($sort, ['priceASC', 'priceDESC', 'clickASC', 'clickDESC', 'timeASC', 'timeDESC'])) {
            $searchArray['sort'] = $sort;
        }

        $this->layout()->setVariables([
            'titleName'         => $brandInfo->getBrandName(),
            'extendTitleName'   => $brandInfo->getBrandNameExtend(),
            'extendKeywords'    => $brandInfo->getBrandKeywords(),
            'extendDescription' => $brandInfo->getBrandDescription()
        ]);

        //品牌商品列表
        $page       = (int) $this->params()->fromQuery('page', 1);
        $query      = $this->entityManager->getRepository(Goods::class)->findShopBrandGoodsList($searchArray, $this->shopPlugin()->getUserLoginData('user_group_id'));
        $paginator  = $this->shopPlugin()->shopPaginator($query, $page, $this->shopPlugin()->shopPerPageNum('brandGoodsList'));

        $brandGoodsListPartial = $this->shopPlugin()->shopPartial('brandGoodsList');

        return [
            'brandInfo'     => $brandInfo,
            'brandGoodsList'=> $paginator,
            'searchArray'   => $searchArray,

            'brandGoodsListPartial' => $brandGoodsListPartial
        ];
    }
}