<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller;

use Doctrine\ORM\EntityManager;
use Goods\Entity\Goods;
use Goods\Entity\GoodsBrand;
use Goods\Entity\GoodsBrandInClass;
use Goods\Entity\GoodsClass;
use Goods\Entity\GoodsTag;
use Goods\Entity\GoodsTagGroup;
use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\Mvc\I18n\Translator;

class ClassController extends AbstractActionController
{
    private $translator;
    private $entityManager;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;
    }

    /**
     * 商品分类
     * @return array|\Laminas\View\Model\ViewModel
     */
    public function indexAction()
    {
        $this->layout()->setVariable('titleName', $this->translator->translate('商品分类'));

        $classPartial = $this->shopPlugin()->shopPartial('class');

        return ['classPartial' => $classPartial];
    }

    /**
     * 分类商品列表
     * @return array|\Laminas\Http\Response
     */
    public function goodsListAction()
    {
        $searchArray = [];

        $brandId = (int) $this->params()->fromQuery('brandId', 0);
        $searchArray['brandId'] = $brandId;

        $tagGroupId = (int) $this->params()->fromQuery('tagGroupId', 0);
        $tagIdArray = $this->params()->fromQuery('tag');
        if(!empty($tagIdArray)) {
            $searchArray['tag'] = $tagIdArray;
            if($tagGroupId > 0 && isset($searchArray['tag'][$tagGroupId])) unset($searchArray['tag'][$tagGroupId]);
        }

        $sort = $this->params()->fromQuery('sort', '');
        if(!empty($sort) && in_array($sort, ['priceASC', 'priceDESC', 'clickASC', 'clickDESC', 'timeASC', 'timeDESC'])) {
            $searchArray['sort'] = $sort;
        }

        $classId = (int) $this->params()->fromRoute('id', 0);
        $classInfo = $this->entityManager->getRepository(GoodsClass::class)->findOneBy(['classId' => $classId, 'classState' => 1]);
        if($classInfo == null) return $this->redirect()->toRoute('shop');

        $this->layout()->setVariables([
            'titleName'         => $classInfo->getClassName(),
            'extendTitleName'   => $classInfo->getClassExtend(),
            'extendKeywords'    => $classInfo->getClassKeywords(),
            'extendDescription' => $classInfo->getClassDescription()
        ]);

        //商品列表
        $page       = (int) $this->params()->fromQuery('page', 1);
        $query      = $this->entityManager->getRepository(Goods::class)->findShopClassGoodsList(array_merge($searchArray, ['inClassId' => $classId]), $this->shopPlugin()->getUserLoginData('user_group_id'));
        $paginator  = $this->shopPlugin()->shopPaginator($query, $page, $this->shopPlugin()->shopPerPageNum('goodsList'));

        //分类里的标签组
        $classTag           = [];
        $classTagGroup      = [];
        $tagGroupIdArray    = unserialize($classInfo->getClassTagGroup());
        if(!empty($tagGroupIdArray)) {
            $classTagGroup  = $this->entityManager->getRepository(GoodsTagGroup::class)->findTagGroupInId($tagGroupIdArray);
            $classTagList   = $this->entityManager->getRepository(GoodsTag::class)->findGoodsTagInTagGroupId($tagGroupIdArray);
            if($classTagList) foreach ($classTagList as $tagValue) {
                $classTag[$tagValue->getTagGroupId()][] = $tagValue;
            }
        }

        //分类下品牌
        $classBrand = $this->entityManager->getRepository(GoodsBrandInClass::class)->findBrandInClass($classId);

        //同级分类
        $currentClass = $this->entityManager->getRepository(GoodsClass::class)->findBy(['classTopId' => $classInfo->getClassTopId(), 'classState' => 1], ['classSort' => 'ASC']);
        //下级分类
        $subClass = $this->entityManager->getRepository(GoodsClass::class)->findBy(['classTopId' => $classId, 'classState' => 1], ['classSort' => 'ASC']);

        $goodsListPartial = $this->shopPlugin()->shopPartial('goodsList');

        return [
            'classInfo'     => $classInfo,
            'classTagGroup' => $classTagGroup,
            'classTag'      => $classTag,
            'currentClass'  => $currentClass,
            'subClass'      => $subClass,
            'classBrand'    => $classBrand,
            'searchArray'   => $searchArray,

            'goodsList'     => $paginator,

            'goodsListPartial' => $goodsListPartial
        ];
    }
}