<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller;

use Cms\Entity\Cms;
use Cms\Entity\CmsClass;
use Cms\Entity\SingleCms;
use Doctrine\ORM\EntityManager;
use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\Mvc\I18n\Translator;

class CmsController extends AbstractActionController
{
    private $translator;
    private $entityManager;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;
    }

    public function indexAction()
    {
        $cmsClassId = $this->params()->fromRoute('id', 0);
        $cmsClassInfo = $this->entityManager->getRepository(CmsClass::class)->findOneBy(['cmsClassId' => $cmsClassId, 'cmsClassState' => 1]);
        if ($cmsClassInfo == null) return $this->redirect()->toRoute('shop');

        $page       = (int) $this->params()->fromQuery('page', 1);
        $query      = $this->entityManager->getRepository(Cms::class)->shopListCms($cmsClassId, []);
        $paginator  = $this->shopPlugin()->shopPaginator($query, $page, $this->shopPlugin()->shopPerPageNum('cmsList'));

        $cmsSubClass = [];
        if ($cmsClassInfo->getCmsClassTopId() == 0) $cmsSubClass = $this->entityManager->getRepository(CmsClass::class)->findBy(['cmsClassTopId' => $cmsClassInfo->getCmsClassId(), 'cmsClassState' =>1], ['cmsClassSort' => 'ASC']);
        $cmsClass    = $this->entityManager->getRepository(CmsClass::class)->findBy(['cmsClassTopId' => $cmsClassInfo->getCmsClassTopId(), 'cmsClassState' => 1], ['cmsClassSort' => 'ASC']);

        return [
            'cmsClassInfo'  => $cmsClassInfo,
            'cmsList'       => $paginator,

            'cmsClass'      => $cmsClass,       //同级分类
            'cmsSubClass'   => $cmsSubClass     //下级分类
        ];
    }

    /**
     * 文章内容
     * @return array|\Laminas\Http\Response
     */
    public function contentAction()
    {
        $cmsId = $this->params()->fromRoute('id', 0);
        $cmsInfo = $this->entityManager->getRepository(Cms::class)->findOneBy(['cmsId' => $cmsId, 'cmsState' => 1]);
        if ($cmsInfo == null) return $this->redirect()->toRoute('shop');
        if (!empty($cmsInfo->getCmsUrl())) return $this->redirect()->toUrl($cmsInfo->getCmsUrl());

        $this->layout()->setVariables([
            'titleName'         => $cmsInfo->getCmsTitle(),
            'extendTitleName'   => $cmsInfo->getCmsExtendTitle(),
            'extendKeywords'    => $cmsInfo->getCmsKeywords(),
            'extendDescription' => $cmsInfo->getCmsDescription()
        ]);

        $cmsClassInfo   = $this->entityManager->getRepository(CmsClass::class)->findOneBy(['cmsClassId' => $cmsInfo->getCmsClassId()]);
        $cmsClass = [];
        if ($cmsClassInfo->getCmsClassTopId() > 0) $cmsClass = $this->entityManager->getRepository(CmsClass::class)->findBy(['cmsClassTopId' => $cmsClassInfo->getCmsClassTopId(), 'cmsClassState' =>1], ['cmsClassSort' => 'ASC']);
        $cmsTopClass    = $this->entityManager->getRepository(CmsClass::class)->findBy(['cmsClassTopId' => 0, 'cmsClassState' => 1], ['cmsClassSort' => 'ASC']);

        return [
            'cmsInfo'       => $cmsInfo,
            'cmsClassInfo'  => $cmsClassInfo,   //当前文章分类详情
            'cmsClass'      => $cmsClass,       //同级分类
            'cmsTopClass'   => $cmsTopClass     //顶级分类
        ];
    }

    /**
     * 单页文章内容
     * @return array|\Laminas\Http\Response
     */
    public function singleAction()
    {
        $singleId = $this->params()->fromRoute('id', 0);
        $singleInfo = $this->entityManager->getRepository(SingleCms::class)->findOneBy(['singleCmsId' => $singleId]);
        if ($singleInfo == null) return $this->redirect()->toRoute('shop');

        $this->layout()->setVariables([
            'titleName'         => $singleInfo->getSingleCmsTitle(),
            'extendTitleName'   => $singleInfo->getSingleCmsExtendTitle(),
            'extendKeywords'    => $singleInfo->getSingleCmsKeywords(),
            'extendDescription' => $singleInfo->getSingleCmsDescription()
        ]);

        return ['singleInfo' => $singleInfo];
    }
}