<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Sales\Service\OrderDeliveryAddressManager;
use Sales\Service\OrderGoodsManager;
use Sales\Service\OrderManager;
use Sales\Service\OrderSelfLocationManager;
use Sales\Service\OrderStatusManager;
use Shop\Controller\CheckoutController;
use User\Service\CartManager;

class CheckoutControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_READ);
        $writeEntityManager = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $cartManager        = $container->get(CartManager::class);
        $orderManager       = $container->get(OrderManager::class);
        $orderDeliveryAddressManager= $container->get(OrderDeliveryAddressManager::class);
        $orderSelfLocationManager   = $container->get(OrderSelfLocationManager::class);
        $orderGoodsManager  = $container->get(OrderGoodsManager::class);
        $orderStatusManager = $container->get(OrderStatusManager::class);

        return new CheckoutController(
            $translator,
            $entityManager,
            $writeEntityManager,
            $cartManager,
            $orderManager,
            $orderDeliveryAddressManager,
            $orderSelfLocationManager,
            $orderGoodsManager,
            $orderStatusManager
        );
    }
}