<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller\Factory;

use Admin\Data\Config;
use Goods\Service\GoodsConsultationManager;
use Goods\Service\GoodsManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Service\UserCouponManager;
use Shop\Controller\GoodsController;
use User\Service\UserGoodsFavoritesManager;

class GoodsControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_READ);
        $goodsConsultationManager = $container->get(GoodsConsultationManager::class);
        $userGoodsFavoritesManager= $container->get(UserGoodsFavoritesManager::class);
        $goodsManager       = $container->get(GoodsManager::class);
        $userCouponManager  = $container->get(UserCouponManager::class);

        return new GoodsController(
            $translator,
            $entityManager,
            $goodsConsultationManager,
            $userGoodsFavoritesManager,
            $goodsManager,
            $userCouponManager
        );
    }
}