<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Service\UserCouponManager;
use Sales\Service\OrderChangeAmountManager;
use Sales\Service\OrderDeliveryAddressManager;
use Sales\Service\OrderDiscountRecordManager;
use Sales\Service\OrderGoodsEvaluationBaseManager;
use Sales\Service\OrderGoodsEvaluationManager;
use Sales\Service\OrderGoodsManager;
use Sales\Service\OrderManager;
use Sales\Service\OrderSelfLocationManager;
use Sales\Service\OrderStatusManager;
use Shop\Controller\HomeOrderController;
use User\Service\UserIntegralConfirmManager;

class HomeOrderControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_READ);
        $writeEntityManager = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $orderManager       = $container->get(OrderManager::class);
        $orderStatusManager = $container->get(OrderStatusManager::class);
        $orderDeliveryAddressManager= $container->get(OrderDeliveryAddressManager::class);
        $orderGoodsManager  = $container->get(OrderGoodsManager::class);
        $orderSelfLocationManager   = $container->get(OrderSelfLocationManager::class);
        $orderChangeAmountManager   = $container->get(OrderChangeAmountManager::class);
        $orderGoodsEvaluationManager= $container->get(OrderGoodsEvaluationManager::class);
        $orderGoodsEvaluationBaseManager = $container->get(OrderGoodsEvaluationBaseManager::class);
        $userIntegralConfirmManager = $container->get(UserIntegralConfirmManager::class);
        $orderDiscountRecordManager = $container->get(OrderDiscountRecordManager::class);
        $userCouponManager  = $container->get(UserCouponManager::class);

        return new HomeOrderController(
            $translator,
            $entityManager,
            $writeEntityManager,
            $orderManager,
            $orderStatusManager,
            $orderDeliveryAddressManager,
            $orderGoodsManager,
            $orderSelfLocationManager,
            $orderChangeAmountManager,
            $orderGoodsEvaluationManager,
            $orderGoodsEvaluationBaseManager,
            $userIntegralConfirmManager,
            $orderDiscountRecordManager,
            $userCouponManager
        );
    }
}