<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Service\RechargeCodeManager;
use Shop\Controller\HomeUserBalanceController;
use User\Service\BalanceLogManager;
use User\Service\UserManager;
use User\Service\UserRechargeManager;
use User\Service\UserWithdrawManager;

class HomeUserBalanceControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_READ);
        $writeEntityManager = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $userRechargeManager= $container->get(UserRechargeManager::class);
        $userWithdrawManager= $container->get(UserWithdrawManager::class);
        $userManager        = $container->get(UserManager::class);
        $balanceLogManager  = $container->get(BalanceLogManager::class);
        $rechargeCodeManager= $container->get(RechargeCodeManager::class);

        return new HomeUserBalanceController(
            $translator,
            $entityManager,
            $writeEntityManager,
            $userRechargeManager,
            $userWithdrawManager,
            $userManager,
            $balanceLogManager,
            $rechargeCodeManager
        );
    }
}