<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\Mvc\MvcEvent;

class HomeActionController extends AbstractActionController
{
    protected static $userId;
    protected static $userName;
    protected static $userGroupId;

    protected function attachDefaultListeners()
    {
        $events = $this->getEventManager();
        $events->attach(MvcEvent::EVENT_DISPATCH, [$this, 'checkUserLoginFilterAccess'], 99);
        parent::attachDefaultListeners();
    }

    /**
     * 检查会员登录状态及权限
     * @param MvcEvent $event
     * @return \Laminas\Http\Response
     */
    public function checkUserLoginFilterAccess(MvcEvent $event)
    {
        if(!$this->shopPlugin()->checkUserLoginStatus()) {
            return $this->redirect()->toRoute('shop-user', [], ['query' => ['httpReferer' => $this->params()->fromHeader('Referer') ? urlencode($this->params()->fromHeader('Referer')->getFieldValue()) : '']]);
        }

        self::$userId       = $this->shopPlugin()->getUserLoginData('user_id');
        self::$userName     = $this->shopPlugin()->getUserLoginData('user_name');
        self::$userGroupId  = $this->shopPlugin()->getUserLoginData('user_group_id');
    }
}