<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller;

use Doctrine\ORM\EntityManager;
use Laminas\Mvc\I18n\Translator;
use Operation\Entity\UserCoupon;

class HomeUserCouponController extends HomeActionController
{
    private $translator;
    private $entityManager;

    private $couponGetType;
    private $userCouponStateArray;

    public function __construct(
        Translator $translator,
        EntityManager $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;

        $this->couponGetType = [
            'buy'   => $this->translator->translate('购物直接获取'),
            'click' => $this->translator->translate('点击直接获取(登录用户)'),
            'register' => $this->translator->translate('注册获取')
        ];
        $this->userCouponStateArray = [
            0 => $this->translator->translate('未生效'),
            1 => $this->translator->translate('可用'),
            2 => $this->translator->translate('已用'),
            3 => $this->translator->translate('已过期'),
        ];
    }

    /**
     * 我的优惠券列表
     * @return array|\Laminas\View\Model\ViewModel
     */
    public function indexAction()
    {
        $this->layout()->setVariable('titleName', $this->translator->translate('优惠券'));

        $page   = (int) $this->params()->fromQuery('page', 1);
        $search = ['coupon_use_state' => $this->params()->fromQuery('state')];
        $query      = $this->entityManager->getRepository(UserCoupon::class)->shopUserCouponList(parent::$userId, $search);
        $paginator  = $this->shopPlugin()->shopPaginator($query, $page);

        return [
            'userCouponList'        => $paginator,
            'userCouponStateArray'  => $this->userCouponStateArray,
            'state' => $search['coupon_use_state']
        ];
    }
}