<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Controller;

use Doctrine\ORM\EntityManager;
use Laminas\Mvc\I18n\Translator;
use User\Entity\IntegralLog;
use User\Entity\User;

class HomeUserIntegralController extends HomeActionController
{
    private $translator;
    private $entityManager;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;
    }

    /**
     * 我的积分
     * @return array|\Laminas\View\Model\ViewModel
     */
    public function indexAction()
    {
        $this->layout()->setVariable('titleName', $this->translator->translate('我的积分'));

        $userInfo = $this->entityManager->getRepository(User::class)->findOneBy(['userId' => parent::$userId]);

        $typeId = (int) $this->params()->fromQuery('type', 1);
        $search     = ['integral_type_id' => $typeId];
        $page       = (int) $this->params()->fromQuery('page', 1);
        $query      = $this->entityManager->getRepository(IntegralLog::class)->shopFindUserIntegralLog(parent::$userId, $search);
        $paginator  = $this->shopPlugin()->shopPaginator($query, $page);

        return ['userInfo' => $userInfo, 'typeId' => $typeId, 'userIntegralLog' => $paginator];
    }
}