<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Event\Factory;

use Admin\Data\Config;
use Goods\Service\GoodsInSpecGoodsManager;
use Goods\Service\GoodsSalesRecordManager;
use Goods\Service\GoodsStockManager;
use Goods\Service\GoodsVirtualManager;
use Interop\Container\ContainerInterface;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Operation\Service\UserCouponManager;
use Sales\Service\OrderDiscountRecordManager;
use Sales\Service\OrderGoodsManager;
use Sales\Service\OrderManager;
use Sales\Service\OrderSelfLocationManager;
use Shop\Event\ShopListener;
use Shop\Service\ShopUserManager;
use User\Service\BalanceLogManager;
use User\Service\IntegralLogManager;
use User\Service\UserIntegralConfirmManager;
use User\Service\UserManager;

class ShopListenerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $entityManager              = $container->get(Config::SHOP_DATABASE_MANAGER_READ);
        $writeEntityManager         = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $shopUserManager            = $container->get(ShopUserManager::class);
        $integralLogManager         = $container->get(IntegralLogManager::class);
        $goodsStockManager          = $container->get(GoodsStockManager::class);
        $goodsInSpecGoodsManager    = $container->get(GoodsInSpecGoodsManager::class);
        $goodsSalesRecordManager    = $container->get(GoodsSalesRecordManager::class);
        $balanceLogManager          = $container->get(BalanceLogManager::class);
        $userManager                = $container->get(UserManager::class);
        $userIntegralConfirmManager = $container->get(UserIntegralConfirmManager::class);
        $orderDiscountRecordManager = $container->get(OrderDiscountRecordManager::class);
        $goodsVirtualManager        = $container->get(GoodsVirtualManager::class);
        $orderManager               = $container->get(OrderManager::class);
        $orderGoodsManager          = $container->get(OrderGoodsManager::class);
        $orderSelfLocationManager   = $container->get(OrderSelfLocationManager::class);
        $userCouponManager          = $container->get(UserCouponManager::class);

        return new ShopListener(
            $entityManager,
            $writeEntityManager,
            $shopUserManager,
            $integralLogManager,
            $goodsStockManager,
            $goodsInSpecGoodsManager,
            $goodsSalesRecordManager,
            $balanceLogManager,
            $userManager,
            $userIntegralConfirmManager,
            $orderDiscountRecordManager,
            $goodsVirtualManager,
            $orderManager,
            $orderGoodsManager,
            $orderSelfLocationManager,
            $userCouponManager
        );
    }
}