<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;

class AddCartForm extends Form
{
    public function __construct($name = 'add-cart-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'number',
            'name'  => 'goodsId',
            'attributes' => [
                'id'    => 'goodsId'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'specTagIdStr',
            'attributes' => [
                'id'    => 'specTagIdStr'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'buyNum',
            'attributes' => [
                'id'    => 'buyNum'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'buyNow',
            'attributes' => [
                'id'    => 'buyNow'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsRemark',
            'attributes' => [
                'id'    => 'goodsRemark'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'goodsId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'specTagIdStr',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyNow',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsRemark',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}