<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;
use Shop\Validator\UserWithdrawMoneyValidator;

class AddUserWithdrawForm extends Form
{
    private $translator;
    private $userInfo;

    public function __construct($userInfo, $name = 'add-user-withdraw-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->translator   = new Translator();
        $this->userInfo     = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'moneyChangeNum',
            'attributes' => [
                'id'    => 'moneyChangeNum'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'bankName',
            'attributes' => [
                'id'    => 'bankName'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'bankAccount',
            'attributes' => [
                'id'    => 'bankAccount'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'bankCardNumber',
            'attributes' => [
                'id'    => 'bankCardNumber'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'moneyChangeNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => UserWithdrawMoneyValidator::class,
                    'options'   => [
                        'userInfo'   => $this->userInfo
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'bankName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'bankAccount',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'bankCardNumber',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}