<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;
use User\Validator\UserEmailExistsValidator;

class ChangeUserEmailForm extends Form
{
    private $entityManager;
    private $userInfo;

    public function __construct($entityManager, $userInfo, $name = 'change-user-email-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->entityManager= $entityManager;
        $this->userInfo     = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'email',
            'name'  => 'userEmail',
            'attributes' => [
                'id' => 'userEmail'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'userEmail',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 100
                    ]
                ],
                [
                    'name'      => UserEmailExistsValidator::class,
                    'options'    => [
                        'entityManager' => $this->entityManager,
                        'userInfo'      => $this->userInfo
                    ]
                ]
            ]
        ]);
    }
}