<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;
use Shop\Validator\UserLoginPasswordValidator;

class ChangeUserLoginPasswordForm extends Form
{
    private $userInfo;

    public function __construct($userInfo, $name = 'change-user-login-password-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->userInfo = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'password',
            'name'  => 'originalPassword',
            'attributes'    => [
                'id'    => 'originalPassword'
            ]
        ]);

        $this->add([
            'type'  => 'password',
            'name'  => 'userPassword',
            'attributes'    => [
                'id'    => 'userPassword'
            ]
        ]);

        $this->add([
            'type'  => 'password',
            'name'  => 'userComPassword',
            'attributes'    => [
                'id'    => 'userComPassword'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'originalPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 6
                    ]
                ],
                [
                    'name'      => UserLoginPasswordValidator::class,
                    'options'   => [
                        'userInfo' => $this->userInfo
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 6
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userComPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'Identical',
                    'options'   => [
                        'token' => 'userPassword'
                    ]
                ]
            ]
        ]);
    }
}