<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;

class GoodsChangeForm extends Form
{
    public function __construct($name = 'goods-change-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'returnReason',
            'attributes'    => [
                'id'            => 'returnReason'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'returnInfo',
            'attributes'    => [
                'id'    => 'returnInfo',
                'rows'  => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'returnInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 1000
                    ]
                ]
            ]
        ]);
    }
}