<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\Form\Form;

class GoodsConsultationForm extends Form
{
    public function __construct($name = 'consult-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'textarea',
            'name'  => 'consultContent',
            'attributes'    => [
                'id'            => 'consultContent'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'consultGoodsId',
            'attributes'    => [
                'id'    => 'consultGoodsId'
            ]
        ]);

        if(Common::configValue('captcha', 'config')['goods_ask_captcha'] == 1) {
            $this->add([
                'type'  => 'captcha',
                'name' => 'consultCaptcha',
                'attributes'    => [
                    'id'            => 'consultCaptcha'
                ],
                'options' => [
                    'captcha' => [
                        'class' => 'Figlet',
                        'wordLen' => 4,
                        'expiration' => 180
                    ],
                ],
            ]);
        }

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'consultContent',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 2000
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'consultGoodsId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);
    }
}