<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class GoodsReturnForm extends Form
{
    private $translator;
    private $maxReturnAmount;

    public function __construct($maxReturnAmount, $name = 'goods-return-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');

        $this->translator = new Translator();
        $this->maxReturnAmount = $maxReturnAmount;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'returnReason',
            'attributes'    => [
                'id'            => 'returnReason'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'refundPayType',
            'attributes'    => [
                'id'            => 'refundPayType'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'returnAmount',
            'attributes'    => [
                'id'            => 'returnAmount'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'refundPayName',
            'attributes'    => [
                'id'            => 'refundPayName'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'refundUser',
            'attributes'    => [
                'id'            => 'refundUser'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'refundAccount',
            'attributes'    => [
                'id'            => 'refundAccount'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'returnInfo',
            'attributes'    => [
                'id'    => 'returnInfo',
                'rows'  => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'returnAmount',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'max'   => $this->maxReturnAmount
                        //'inclusive' => true
                    ]
                ]
            ],
            'error_message' => $this->translator->translate('金额输入错误')
        ]);

        $inputFilter->add([
            'name'      => 'refundPayType',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'refundPayName',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'refundUser',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'refundAccount',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'returnInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 1000
                    ]
                ]
            ]
        ]);
    }
}