<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Common;
use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class GoodsSearchForm extends Form
{
    private $translator;

    public function __construct($name = 'goods-search-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'get');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'keywords',
            'attributes'    => [
                'id'            => 'keywords',
                'placeholder'   => Common::configValue('base', 'config')['shop_place_keywords'] ?? $this->translator->translate('简简单单搜索')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'keywords',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}