<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Filter\ImageThumb;
use Admin\Filter\OldImage;
use Laminas\Form\Form;

class HomeUserEditAvatarForm extends Form
{
    private $userInfo;

    public function __construct($userInfo, $name = 'home-user-avatar-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');

        $this->userInfo = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'file',
            'name'  => 'userAvatar',
            'attributes'    => [
                'id'            => 'userAvatar'
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'userAvatar',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::USER_AVATAR_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true
                    ]
                ],
                [
                    'name' => ImageThumb::class,
                    'options' => [
                        'width'     => 100,
                        'height'    => 100,
                        'mode'      => 'outbound',
                        'rename'    => true,
                        'newName'   => $this->userInfo ? $this->userInfo->getUserId().'_'.time() : time()
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => $this->userInfo ? $this->userInfo->getUserAvatar() : ''
                    ]
                ]
            ]
        ]);
    }
}