<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Laminas\Form\Form;
use Shop\Validator\BalancePayPasswordValidator;

class OrderBalancePayForm extends Form
{
    private $userInfo;

    public function __construct($userInfo, $name = 'add-cart-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->userInfo = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'password',
            'name'  => 'payPassword',
            'attributes'=> [
                'id'    => 'payPassword'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'payPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => BalancePayPasswordValidator::class,
                    'options'   => [
                        'userInfo' => $this->userInfo
                    ]
                ]
            ]
        ]);
    }
}