<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;

class OrderGoodsEvaluationForm extends Form
{
    public function __construct($name = 'order-goods-evaluation-from', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'evaluationStar'
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'evaluationBody',
            'attributes'    => [
                'id'   => 'evaluationBody',
                'rows' => 4
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'evaluationStar',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 2, 3, 4, 5]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'evaluationBody',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 2000
                    ]
                ]
            ]
        ]);
    }
}