<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;
use Shop\Common\ShopCommon;

class OrderPaymentForm extends Form
{
    private $paymentCodeArray;
    private $entityManager;
    private $translator;

    public function __construct($paymentList, $entityManager, $name = 'order-payment-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');

        $this->paymentCodeArray = ShopCommon::createPaymentCodeArray($paymentList);
        $this->entityManager    = $entityManager;
        $this->translator       = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'hidden',
            'name'  => 'paymentCode',
            'attributes' => [
                'id'    => 'paymentCode'
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'paymentCode',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => $this->paymentCodeArray
                    ]
                ]
            ],
            'error_message' => $this->translator->translate('请选择支付方式')
        ]);
    }
}