<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;
use Shop\Validator\UserLoginValidator;

class OtherUserLoginForm extends Form
{
    private $entityManager;

    public function __construct($entityManager, $name = 'other-user-login', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->entityManager = $entityManager;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'loginAccount',
            'attributes' => [
                'id'    => 'loginAccount'
            ]
        ]);

        $this->add([
            'type'  => 'password',
            'name'  => 'loginPassword',
            'attributes' => [
                'id'    => 'loginPassword'
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'loginAccount',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators' => [
                [
                    'name'      => UserLoginValidator::class,
                    'options'   => [
                        'entityManager' => $this->entityManager
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'loginPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);
    }
}