<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;
use Shop\Validator\PhoneCaptchaValidator;

class PhoneForgetPasswordForm extends Form
{
    private $phoneArea;

    public function __construct($step, array $phoneArea = [], $name = 'phone-forget-password-form', $options = [])
    {
        if(!is_int($step) || $step < 1 || $step > 3) exit('无效的请求');

        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->phoneArea    = $phoneArea;

        $this->addElements($step);
        $this->addInputFilter($step);
    }

    protected function addElements($step)
    {
        if ($step == 1) {
            if (count($this->phoneArea) == 1) {
                $this->add([
                    'type'  => 'hidden',
                    'name'  => 'areaCode',
                    'attributes'=> [
                        'id'    => 'areaCode',
                        'value' => $this->phoneArea[0]['areaCode']
                    ]
                ]);
            } else {
                $this->add([
                    'type'  => 'select',
                    'name'  => 'areaCode',
                    'attributes'=> [
                        'id'    => 'areaCode',
                        'value' => $this->phoneArea['default']
                    ],
                    'options' => [
                        'value_options' => $this->phoneArea['list']
                    ]
                ]);
            }

            $this->add([
                'type'  => 'text',
                'name'  => 'userPhone',
                'attributes'=> [
                    'id'    => 'userPhone'
                ]
            ]);
        }

        if ($step == 2) {
            $this->add([
                'type'  => 'text',
                'name'  => 'phoneCaptcha',
                'attributes'=> [
                    'id'    => 'phoneCaptcha'
                ]
            ]);
        }

        if ($step == 3) {
            $this->add([
                'type'  => 'password',
                'name'  => 'userPassword',
                'attributes'=> [
                    'id'    => 'userPassword'
                ]
            ]);

            $this->add([
                'type'  => 'password',
                'name'  => 'userComPassword',
                'attributes'    => [
                    'id'            => 'userComPassword'
                ]
            ]);
        }

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter($step)
    {
        $inputFilter = $this->getInputFilter();

        if ($step == 1) {
            $inputFilter->add([
                'name'      => 'userPhone',
                'required'  => true,
                'filters'   => [
                    ['name' => 'StringTrim'],
                    ['name' => 'StripTags'],
                    ['name' => 'HtmlEntities']
                ],
                'validators'=> [
                    [
                        'name'      => 'StringLength',
                        'options'   => [
                            'min'   => 1,
                            'max'   => 30
                        ]
                    ]
                ]
            ]);
        }

        if ($step == 2) {
            $inputFilter->add([
                'name'      => 'phoneCaptcha',
                'required'  => true,
                'filters'   => [
                    ['name' => 'ToInt']
                ],
                'validators'=> [
                    [
                        'name' => PhoneCaptchaValidator::class
                    ]
                ]
            ]);
        }

        if ($step == 3) {
            $inputFilter->add([
                'name'      => 'userPassword',
                'required'  => true,
                'filters'   => [
                    ['name' => 'StringTrim']
                ],
                'validators'=> [
                    [
                        'name'      => 'StringLength',
                        'options'   => [
                            'min'   => 6
                        ]
                    ]
                ]
            ]);

            $inputFilter->add([
                'name'      => 'userComPassword',
                'required'  => true,
                'filters'   => [
                    ['name' => 'StringTrim']
                ],
                'validators'=> [
                    [
                        'name'      => 'Identical',
                        'options'   => [
                            'token' => 'userPassword'
                        ]
                    ]
                ]
            ]);
        }
    }
}