<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;
use User\Validator\PhoneValidator;

class UserAddressForm extends Form
{
    private $phoneArea;

    public function __construct(array $phoneArea, $name = 'user-address-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->phoneArea = $phoneArea;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'trueName',
            'attributes'=> [
                'id'    => 'trueName'
            ]
        ]);

        if(count($this->phoneArea) == 1) {
            $this->add([
                'type'  => 'hidden',
                'name'  => 'areaCode',
                'attributes'=> [
                    'id'    => 'areaCode',
                    'value' => $this->phoneArea[0]['areaCode']
                ]
            ]);
        } else {
            $this->add([
                'type'  => 'select',
                'name'  => 'areaCode',
                'attributes'=> [
                    'id'    => 'areaCode',
                    'value' => $this->phoneArea['default']
                ],
                'options' => [
                    'value_options' => $this->phoneArea['list']
                ]
            ]);
        }

        $this->add([
            'type'  => 'text',
            'name'  => 'phone',
            'attributes'=> [
                'id'    => 'phone'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'regionId',
            'attributes'    => [
                'id'            => 'regionId',
                'class'         => 'region_ids'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'regionValue',
            'attributes'    => [
                'id'            => 'regionValue',
                'class'         => 'region_names'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'addressInfo',
            'attributes'=> [
                'id'    => 'addressInfo'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'postCode',
            'attributes'=> [
                'id'    => 'postCode'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'addrDefault',
            'attributes'    => [
                'id'            => 'addrDefault',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'trueName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 100
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'phone',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                ['name' => PhoneValidator::class],
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 30
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'regionId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'regionValue',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'addressInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 500
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'postCode',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 20
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'addrDefault',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}