<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;
use Shop\Validator\UserRechargeCodeValidator;

class UserRechargeCodeForm extends Form
{
    private $entityManager;

    public function __construct($entityManager, $name = 'user-recharge-code-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');

        $this->entityManager    = $entityManager;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'rechargeCode',
            'attributes' => [
                'id'    => 'rechargeCode'
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'rechargeCode',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => UserRechargeCodeValidator::class,
                    'options'    => [
                        'entityManager'     => $this->entityManager
                    ]
                ]
            ]
        ]);
    }
}